/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utility {
    private static Map<Class, Collection<Class>> classCache = new HashMap<Class, Collection<Class>>();

    private static Set<Class> findClasses(String pckgname, Class clazz) {
        URL url;
        HashSet<Class> output = new HashSet<Class>();
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = Utility.class.getResource(name = name.replace('.', '/'))) == null || url.getFile().contains("jre/lib")) {
            return output;
        }
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            return Utility.findClassesInJar(url, clazz);
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            for (String filename : directory.list()) {
                char firstLetter = filename.charAt(0);
                if (firstLetter < 'A' || firstLetter > 'Z' && firstLetter < 'a' || firstLetter > 'z' || !filename.endsWith(".class")) continue;
                String classname = filename.substring(0, filename.length() - 6);
                try {
                    String className = pckgname + "." + classname;
                    Class<?> c = Class.forName(className);
                    if (!clazz.isAssignableFrom(c)) continue;
                    output.add(c);
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Class> findClassesInJar(URL jarLocation, Class clazz) {
        HashSet<Class> output = new HashSet<Class>();
        JarFile jarFile = null;
        try {
            JarURLConnection conn = (JarURLConnection)jarLocation.openConnection();
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            String last = "";
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().equals(last)) {
                    HashSet<Class> hashSet = output;
                    return hashSet;
                }
                last = jarEntry.getName();
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName();
                className = className.substring(0, className.length() - 6);
                className = className.replaceAll("/", "\\.");
                try {
                    Class<?> c = Class.forName(className);
                    if (!clazz.isAssignableFrom(c)) continue;
                    output.add(c);
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return output;
    }

    public static List<Class> findAllSubclasses(Class clazz) {
        if (classCache.containsKey(clazz)) {
            return (List)classCache.get(clazz);
        }
        TreeMap<String, Class> allClasses = new TreeMap<String, Class>();
        for (Package p : Package.getPackages()) {
            if (p.getName().startsWith("java") || p.getName().startsWith("com.sun") || p.getName().startsWith("com.oracle")) continue;
            for (Class c : Utility.findClasses(p.getName(), clazz)) {
                if (Modifier.isAbstract(c.getModifiers())) continue;
                allClasses.put(c.getSimpleName(), c);
            }
        }
        ArrayList<Class> values = new ArrayList<Class>(allClasses.values());
        classCache.put(clazz, values);
        return values;
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null || s.length() == 0 || t.length() == 0) {
            return -1;
        }
        s = s.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        t = t.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        int m = s.length();
        int n = t.length();
        int[][] dist = new int[m + 1][n + 1];
        for (i = 1; i <= m; ++i) {
            dist[i][0] = i;
        }
        for (i = 1; i <= n; ++i) {
            dist[0][i] = i;
        }
        for (int j = 1; j <= n; ++j) {
            for (int i2 = 1; i2 <= m; ++i2) {
                if (s.charAt(i2 - 1) == t.charAt(j - 1)) {
                    dist[i2][j] = dist[i2 - 1][j - 1];
                    continue;
                }
                int del = dist[i2 - 1][j] + 1;
                int insert = dist[i2][j - 1] + 1;
                int sub = dist[i2 - 1][j - 1] + 1;
                dist[i2][j] = Math.min(Math.min(del, insert), sub);
            }
        }
        return Math.max(m, n) - dist[m][n];
    }

    public static double rankMatch(String c1, String c2, int width) {
        double score = 0.0;
        String s1 = c1.toLowerCase();
        String s2 = c2.toLowerCase();
        for (int i = 0; i < s1.length() + 1 - width; ++i) {
            String m = s1.substring(i, i + width);
            int j = 0;
            while ((j = s2.indexOf(m, j)) > -1) {
                score += (double)width;
                ++j;
            }
        }
        double l1 = s1.length();
        double l2 = s2.length();
        double adjustment = Math.min(l1, l2) / Math.max(l1, l2) + 0.1;
        return score * adjustment * adjustment;
    }

    public static String findBestMatch(String match, Collection<String> search) {
        if (search == null || search.isEmpty()) {
            return null;
        }
        RankingComparator r = new RankingComparator(match);
        ArrayList<String> candidates = new ArrayList<String>(search);
        Collections.sort(candidates, r);
        double score = Utility.levenshteinDistance(match, (String)candidates.get(0));
        if (score > 1.0) {
            return (String)candidates.get(0);
        }
        return null;
    }

    public static class RankingComparator
    implements Comparator<String> {
        String match;

        public RankingComparator(String match) {
            this.match = match + " ";
        }

        @Override
        public int compare(String o1, String o2) {
            double s1 = Utility.levenshteinDistance(this.match, o1);
            double s2 = Utility.levenshteinDistance(this.match, o2);
            if (s2 == s1) {
                s1 = Utility.rankMatch(o1, this.match, 3) + Utility.rankMatch(o1, this.match, 2);
                s2 = Utility.rankMatch(o2, this.match, 3) + Utility.rankMatch(o2, this.match, 2);
                if (s2 == s1) {
                    return o1.compareTo(o2);
                }
                return (int)Math.signum(s2 - s1);
            }
            return (int)(s2 - s1);
        }
    }
}

